/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.fw.rcs.sas.SasUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CompanyIdentifier
implements Serializable {
    private static final String TRACE_MASKT = "XSASCIDT";
    private static final String TRACE_MASKF = "XSASCIDD";
    private static final String TRACE_MASKD = "XSASCIDF";
    public String companyName;
    public String companyNameForSystem;
    public String companyPhoneNumber;
    public String companyPhoneExtension;
    public String companyEmail;
    public String customerNumber;
    public String enterpriseNumber;
    public Locale locale;
    public Date lastUpdateTimestamp;
    private static final String COMPANY_IDENTIFIER = "company-identifier";
    private static final String COMPANY_NAME = "company-name";
    private static final String COMPANY_NAME_FOR_SYSTEM = "company-name-for-system";
    private static final String COMPANY_PHONE_NUMBER = "company-phone-number";
    private static final String COMPANY_PHONE_EXTENSION = "company-phone-extension";
    private static final String COMPANY_EMAIL = "company-email";
    private static final String CUSTOMER_NUMBER = "ibm-customer-number";
    private static final String ENTERPRISE_NUMBER = "ibm-enterprise-number";
    private static final String LOCALE = "locale";
    private static final String LAST_UPDATE_TIMESTAMP = "last-update_TIMESTAMP";

    public CompanyIdentifier(String companyName, String companyNameForSystem, String companyPhoneNumber, Date lastUpdateTimestamp) {
        this(companyName, companyNameForSystem, companyPhoneNumber, null, null, null, null, null, lastUpdateTimestamp);
        Trace.trace(TRACE_MASKT, "<> CompanyIdentifier.CompanyIdentifier(companyName=" + companyName + ", " + "companyNameForSystem=" + companyNameForSystem + ", " + "companyPhoneNumber=" + companyPhoneNumber + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public CompanyIdentifier(String companyName, String companyNameForSystem, String companyPhoneNumber, String companyPhoneExtension, String companyEmail, String customerNumber, String enterpriseNumber, Locale locale, Date lastUpdateTimestamp) {
        this.companyName = companyName;
        this.companyNameForSystem = companyNameForSystem;
        this.companyPhoneNumber = companyPhoneNumber;
        this.companyPhoneExtension = companyPhoneExtension;
        this.companyEmail = companyEmail;
        this.customerNumber = customerNumber;
        this.enterpriseNumber = enterpriseNumber;
        this.locale = locale;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        Trace.trace(TRACE_MASKT, "<> CompanyIdentifier.CompanyIdentifier(companyName=" + companyName + ", " + "companyNameForSystem=" + companyNameForSystem + ", " + "companyPhoneNumber=" + companyPhoneNumber + ", " + "companyPhoneExtension=" + companyPhoneExtension + ", " + "companyEmail=" + companyEmail + ", " + "customerNumber=" + customerNumber + ", " + "enterpriseNumber=" + enterpriseNumber + ", " + "locale=" + locale + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public String toXml() {
        Trace.trace(TRACE_MASKT, "-> CompanyIdentifier.toXml()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(COMPANY_IDENTIFIER);
        buffer.append(" ");
        buffer.append("company-name=\"" + SasUtil.convert4Xml(this.companyName) + "\"");
        buffer.append(" ");
        buffer.append("company-name-for-system=\"" + SasUtil.convert4Xml(this.companyNameForSystem) + "\"");
        buffer.append(" ");
        buffer.append("company-phone-number=\"" + SasUtil.convert4Xml(this.companyPhoneNumber) + "\"");
        if (this.companyPhoneExtension != null && this.companyPhoneExtension.length() > 0) {
            buffer.append(" ");
            buffer.append("company-phone-extension=\"" + SasUtil.convert4Xml(this.companyPhoneExtension) + "\"");
        }
        if (this.companyEmail != null && this.companyEmail.length() > 0) {
            buffer.append(" ");
            buffer.append("company-email=\"" + SasUtil.convert4Xml(this.companyEmail) + "\"");
        }
        if (this.customerNumber != null && this.customerNumber.length() > 0) {
            buffer.append(" ");
            buffer.append("ibm-customer-number=\"" + SasUtil.convert4Xml(this.customerNumber) + "\"");
        }
        if (this.enterpriseNumber != null && this.enterpriseNumber.length() > 0) {
            buffer.append(" ");
            buffer.append("ibm-enterprise-number=\"" + SasUtil.convert4Xml(this.enterpriseNumber) + "\"");
        }
        if (this.locale != null) {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(this.locale.toString()) + "\"");
        } else {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(Locale.getDefault().toString()) + "\"");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        buffer.append(" ");
        buffer.append("last-update_TIMESTAMP=\"" + SasUtil.convert4Xml(simpleDateFormat.format(this.lastUpdateTimestamp)) + "\"");
        buffer.append("/>");
        Trace.trace(TRACE_MASKT, "<- CompanyIdentifier.toXml()");
        return buffer.toString();
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> CompanyIdentifier.clone()");
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- CompanyIdentifier.clone()");
        return object;
    }

    public boolean equals(Object object) {
        Trace.trace(TRACE_MASKT, "-> CompanyIdentifier.equals(" + object + ")");
        boolean result = false;
        if (object != null && object instanceof CompanyIdentifier) {
            CompanyIdentifier companyIdentifier = (CompanyIdentifier)object;
            if (this.companyName.equals(companyIdentifier.companyName) && this.companyNameForSystem.equals(companyIdentifier.companyNameForSystem) && this.companyPhoneNumber.equals(companyIdentifier.companyPhoneNumber) && this.companyPhoneExtension.equals(companyIdentifier.companyPhoneExtension) && this.companyEmail.equals(companyIdentifier.companyEmail) && this.customerNumber.equals(companyIdentifier.customerNumber) && this.enterpriseNumber.equals(companyIdentifier.enterpriseNumber) && this.locale.equals(companyIdentifier.locale) && this.lastUpdateTimestamp.equals(companyIdentifier.lastUpdateTimestamp)) {
                result = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- CompanyIdentifier.equals()");
        return result;
    }
}

